% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Sigma_cal}
\alias{Sigma_cal}
\title{Variance-covariance matrix of the estimation equation}
\usage{
Sigma_cal(
  X_lab,
  X_unlab,
  Y_lab,
  Yhat_lab,
  Yhat_unlab,
  w,
  theta,
  quant = NA,
  A_lab_inv,
  A_unlab_inv,
  method
)
}
\arguments{
\item{X_lab}{Array or DataFrame containing observed covariates in labeled data.}

\item{X_unlab}{Array or DataFrame containing observed or predicted covariates in unlabeled data.}

\item{Y_lab}{Array or DataFrame of observed outcomes in labeled data.}

\item{Yhat_lab}{Array or DataFrame of predicted outcomes in labeled data.}

\item{Yhat_unlab}{Array or DataFrame of predicted outcomes in unlabeled data.}

\item{w}{weights vector POP-Inf linear regression (d-dimensional, where d equals the number of covariates).}

\item{theta}{parameter theta}

\item{quant}{quantile for quantile estimation}

\item{A_lab_inv}{Inverse of matrix A using labeled data}

\item{A_unlab_inv}{Inverse of matrix A using unlabeled data}

\item{method}{indicates the method to be used for M-estimation. Options include "mean", "quantile", "ols", "logistic", and "poisson".}
}
\value{
variance-covariance matrix of the estimation equation
}
\description{
\code{Sigma_cal} function for variance-covariance matrix of the estimation equation
}
