% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{summary.mpPLMIX}
\alias{summary.mpPLMIX}
\title{Summary of the MAP estimation for a Bayesian mixture of Plackett-Luce models}
\usage{
\method{summary}{mpPLMIX}(object, digits = 2, ...)
}
\arguments{
\item{object}{Object of class \code{mpPLMIX} returned by the \code{mapPLMIX} or \code{mapPLMIX_multistart} function.}

\item{digits}{Number of decimal places for rounding the summaries.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
A list of summaries for the \code{mpPLMIX} class object:

 \item{\code{MAP_w}}{ Numeric vector with the MAP estimates of the \eqn{G} mixture weights. Returned only when when \eqn{G>1}.}
 \item{\code{MAP_p}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the MAP estimates of the component-specific support parameters.}
 \item{\code{MAP_modal_orderings}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the estimated modal orderings of each mixture component.}
 \item{\code{group_distr}}{ Numeric vector with the relative frequency distribution of the mixture component memberships based on MAP allocation. Returned only when when \eqn{G>1}.}
 \item{\code{perc_conv_rate}}{ Numeric scalar with the percentage of MAP algorithm convergence over the multiple starting points. Returned only when \code{summary.mpPLMIX} is applied to the output of the \code{mapPLMIX_multistart} function.}
}
\description{
\code{summary} method for class \code{mpPLMIX}. It provides summaries for the MAP estimation of a Bayesian mixture of Plackett-Luce models.
}
\examples{

## Summary of the MAP procedure with a single starting point
data(d_carconf)
MAP <- mapPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3)
summary(MAP)

## Summary of the MAP procedure with 5 starting points
MAP_multi <- mapPLMIX_multistart(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_start=5)
summary(MAP_multi)
}
\author{
Cristina Mollica and Luca Tardella
}
