% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/chromatogram.R
\name{is_integrated}
\alias{is_integrated}
\alias{is_integrated,ChromRes-method}
\alias{is_integrated,ChromResBase-method}
\title{Check if peak was integrated for a specific compound}
\usage{
is_integrated(chrom_res, compound_id, sample_id = NULL)

\S4method{is_integrated}{ChromRes}(chrom_res, compound_id, sample_id = NULL)

\S4method{is_integrated}{ChromResBase}(chrom_res, compound_id, sample_id = NULL)
}
\arguments{
\item{chrom_res}{ChromRes or ChromResBase object}

\item{compound_id}{Compound ID}

\item{sample_id}{Sample ID. If NULL, all samples are checked}
}
\value{
logical
}
\description{
Check if peak was integrated for a specific compound
}
\examples{
\dontrun{
lapply(1:10, \(x) is_integrated(chrom_res, sample_id = 1, compound_id = 1))
}
}
