% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{fill_scheme}
\alias{fill_scheme}
\title{Filling orientation of the plate}
\usage{
fill_scheme(
  plate,
  fill = "h",
  tbound = "A",
  bbound = "H",
  lbound = 1,
  rbound = 12
)
}
\arguments{
\item{plate}{PlateObj}

\item{fill}{character. Filling scheme. Either "h" for horizontal, "v" for vertical.}

\item{tbound}{character. Top bound of the filling scheme. Default is "A"}

\item{bbound}{character. Bottom bound of the filling scheme. Default is "H"}

\item{lbound}{numeric. Left bound of the filling scheme. Default is 1}

\item{rbound}{numeric. Right bound of the filling scheme. Default is 12}
}
\value{
PlateObj
}
\description{
This function sets the filling scheme of the plate. The filling scheme is used to determine the order in which the samples are filled in the plate.
The default filling scheme is horizontal, which means that the samples are filled from left to right and top to bottom. 
The vertical filling scheme means that the samples are filled from top to bottom and left to right.
}
