% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{RPE}
\alias{RPE}
\title{RPE: Relative Prediction Error}
\usage{
RPE(pred, true_label)
}
\arguments{
\item{pred}{The predicted values of the dataset.}

\item{true_label}{The actual target values of the dataset.}
}
\value{
A numeric value representing the relative prediction error (RPE).
}
\description{
This function takes predicted values and target values to evaluate the performance of a PIE model.
The formula for RPE is:
\deqn{RPE = \frac{\sum_i (y_i - \hat{y}_i)^2}{\sum_i (y_i - \bar{y})^2}}
where \eqn{\bar{y} = \frac{1}{n}\sum_i^n y_i}.
}
\examples{
\donttest{
# Load the training data
data("winequality")

# Which columns are numerical?
num_col <- 1:11
# Which columns are categorical?
cat_col <- 12
# Which column is the response?
y_col <- ncol(winequality)

# Data Processing (the first 200 rows are sampled for demonstration)
dat <- data_process(X = as.matrix(winequality[1:200, -y_col]), 
  y = winequality[1:200, y_col], 
  num_col = num_col, cat_col = cat_col, y_col = y_col)

# Fit a PIE model
fold <- 1
fit <- PIE_fit(
  X = dat$spl_train_X[[fold]],
  y = dat$train_y[[fold]],
  lasso_group = dat$lasso_group,
  X_orig = dat$orig_train_X[[fold]],
  lambda1 = 0.01, lambda2 = 0.01, iter = 5, eta = 0.05, nrounds = 200
)

# Prediction
pred <- predict(fit, 
  X = dat$spl_validation_X[[fold]],
  X_orig = dat$orig_validation_X[[fold]]
)

# Validation
val_rrmse_test <- RPE(pred$total, dat$validation_y[[fold]])
}
}
