% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameter_estimation_and_hypothesis_testing.R
\name{two.sample.test}
\alias{two.sample.test}
\title{Two sample test for \eqn{\psi}}
\usage{
two.sample.test(s1, s2)
}
\arguments{
\item{s1, s2}{The two data vectors to be tested.}
}
\value{
Gives a vector with the Likelihood Ratio Test -statistic \code{Lambda}, as well as the
p-value of the test \code{p}.
}
\description{
Likelihood ratio test for the hypotheses \eqn{H_0: \: \psi_1=\psi_2} and
\eqn{H_1: \: \psi_1 \neq \psi_2}, where \eqn{\psi_1} and \eqn{\psi_2} are the
dispersal parameters of two input samples \code{s1} and \code{s2}.
}
\details{
Calculates the Likelihood Ratio Test statistic
\deqn{-2log(L(\hat{\psi})/L(\hat{\psi}_1, \hat{\psi}_2)),}
where L is the likelihood function of observing the two input samples given
a single \eqn{\psi} in the numerator and two different parameters \eqn{\psi_1}
and \eqn{\psi_2} for each sample respectively in the denominator. According
to the theory of Likelihood Ratio Tests, this statistic converges in
distribution to a \eqn{\chi_d^2}-distribution under the null-hypothesis, where \eqn{d} is the
difference in the amount of parameters between the considered models, which
is 1 here. To calculate the statistic, the Maximum Likelihood Estimate for
\eqn{\psi_1,\: \psi_2} of \eqn{H_1} and the shared \eqn{\psi} of \eqn{H_0}
are calculated.
}
\examples{
##Create samples with different n and psi:
set.seed(111)
x<-rPD(500, 15)
y<-rPD(1000, 20)
z<-rPD(800, 30)
##Run tests
two.sample.test(x,y)
two.sample.test(x,z)
two.sample.test(y,z)
}
\references{
Neyman, J., & Pearson, E. S. (1933). On the problem of the most
efficient tests of statistical hypotheses. Philosophical Transactions of the
Royal Society of London. Series A, Containing Papers of a Mathematical Or
Physical Character, 231(694-706), 289-337. <\doi{10.1098/rsta.1933.0009}>.
}
