% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classifier.R
\name{tMarLab}
\alias{tMarLab}
\title{Marginally predicted labels of the test data given training data classification.}
\usage{
tMarLab(training, x)
}
\arguments{
\item{training}{A training data object from the function \code{classifier.fit()}.}

\item{x}{Test data vector or matrix with rows as data points and columns as features.}
}
\value{
A vector of predicted labels for test data x.
}
\description{
Classifies the test data \code{x} based on the training data object.
The test data is considered i.i.d., so each
data point is classified one by one.
}
\details{
Independently assigns a class label for each test data point according to a
\eqn{maximum \, a \, posteriori} rule. The predictive probability of data point
\eqn{x_i} arising from class \eqn{c} assuming the training data of size \eqn{m_c} in the class
arises from a Poisson-Dirichlet(\eqn{\hat{\psi}_c}) distribution is:
\deqn{\hat{\psi}_c / (m_c + \hat{\psi}_c),}
if no value equal to \eqn{x_i} exists in the training data of class \eqn{c}, and
\deqn{m_{ci} / (m_c + \hat{\psi}_c),}
if there does, where \eqn{m_{ci}} is the frequency of the value of \eqn{x_i}
in the training data.
}
\examples{
## Create random samples x from Poisson-Dirichlet distributions with different
## psis, treating each sample as coming from a class of its own:
set.seed(111)
x1<-rPD(10500,10)
x2<-rPD(10500,1000)
test.ind1<-sample.int(10500,500) # Sample test datasets from the
test.ind2<-sample.int(10500,500) # original samples
x<-c(x1[-test.ind1],x2[-test.ind2])
## create training data labels:
y1<-rep("1", 10000)
y2<-rep("2", 10000)
y<-c(y1,y2)

## Test data t, with first half belonging to class "1", second have in "2":
t1<-x1[test.ind1]
t2<-x2[test.ind2]
t<-c(t1,t2)

fit<-classifier.fit(x,y)

## Run the classifier, which returns
tM<-tMarLab(fit, t)

##With multidimensional x:
set.seed(111)
x1<-cbind(rPD(5500,10),rPD(5500,50))
x2<-cbind(rPD(5500,100),rPD(5500,500))
test.ind1<-sample.int(5500,500)
test.ind2<-sample.int(5500,500)
x<-rbind(x1[-test.ind1,],x2[-test.ind2,])
y1<-rep("1", 5000)
y2<-rep("2", 5000)
y<-c(y1,y2)
fit<-classifier.fit(x,y)
t1<-x1[test.ind1,]
t2<-x2[test.ind2,]
t<-rbind(t1,t2)

tM<-tMarLab(fit, t)
}
\references{
Amiryousefi A. Asymptotic supervised predictive classifiers under
partition exchangeability. . 2021. \url{https://arxiv.org/abs/2101.10950}.

Corander, J., Cui, Y., Koski, T., and Siren, J.: Have I seen you before?
Principles of Bayesian predictive classification revisited. Springer, Stat.
Comput. 23, (2011), 59–73, (<\doi{10.1007/s11222-011-9291-7}>).
}
\keyword{Marginal}
\keyword{classifier}
