% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_log_cumhaz}
\alias{f_plot_log_cumhaz}
\title{Log-Log Survival Diagnostic Plot}
\usage{
f_plot_log_cumhaz(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
A base R plot showing ln(-ln(S(t))) against ln(time).
}
\description{
Creates a log(-log(S(t))) vs log(time) plot to visually assess proportional hazards.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_log_cumhaz(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
