% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_cum_hazard}
\alias{f_cum_hazard}
\title{Calculate Cumulative Hazard Estimates}
\usage{
f_cum_hazard(years, status, group, ngroups, time_pred, time_unit)
}
\arguments{
\item{years}{Numeric vector of time-to-event data.}

\item{status}{Numeric vector indicating event occurrence (1 = event, 0 = censoring).}

\item{group}{Factor indicating group membership.}

\item{ngroups}{Integer. Number of groups (1-3).}

\item{time_pred}{Numeric vector of prediction times.}

\item{time_unit}{Numeric. Time unit length for scaling.}
}
\value{
A data frame with columns:
\itemize{
\item \code{group}: Group identifier.
\item \code{time}: Prediction times.
\item \code{H}: Cumulative hazard values.
\item \code{var}: Variance estimates.
\item \code{H_upper}, \code{H_lower}: 95\% confidence interval bounds.
\item \code{H_delta}, \code{H_upper_delta}, \code{H_lower_delta}: Differences between time steps.
}
}
\description{
Computes cumulative hazard estimates for up to three groups along with
variance and confidence intervals, using the \pkg{estimateNAH} package.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
f_cum_hazard(
  years = years,
  status = status,
  group = group,
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  time_unit = 30
)

}
