% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cornish_fisher.r
\name{rapx_cf}
\alias{rapx_cf}
\title{Approximate random generation via Cornish-Fisher expansion.}
\usage{
rapx_cf(n, raw.cumulants, support=c(-Inf,Inf))
}
\arguments{
\item{n}{number of observations. If 'length(n) > 1', the length is
taken to be the number required.}

\item{raw.cumulants}{an atomic array of the 1st through kth raw cumulants. The first 
value is the mean of the distribution, the second should
be the variance of the distribution, the remainder are raw cumulants.}

\item{support}{the support of the density function. It is assumed
that the density is zero on the complement of this open interval.
This defaults to \code{c(-Inf,Inf)} for the normal basis,
\code{c(0,Inf)} for the gamma basis, and
\code{c(0,1)} for the Beta, and 
\code{c(-1,1)} for the arcsine and wigner.}
}
\value{
A vector of approximate draws.
}
\description{
Approximate random generation via approximate quantile function.
}
\details{
Given the cumulants of a probability distribution, we approximate the 
quantile function via a Cornish-Fisher expansion.
}
\examples{
# normal distribution:
r1 <- rapx_cf(1000, c(0,1,0,0,0,0,0))
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
\code{\link{qapx_cf}}
}
\keyword{distribution}

