% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.r
\name{PCS_convergence_McCandR}
\alias{PCS_convergence_McCandR}
\title{Check a PCS network for convergence}
\usage{
PCS_convergence_McCandR(iteration, current_energy, memory.matrix,
  stability_criterion = 10^-6, output = "qualitative")
}
\arguments{
\item{iteration}{The iteration to consider -- in most cases, this will be the
current iteration during a simulation run, however, the check can also be
applied to a model output retroactively, and the iteration specified
manually.}

\item{current_energy}{The current energy level within the network}

\item{memory.matrix}{A matrix of iteration, energy and node states (in
columns, in that order), across all previous iterations (in rows).}

\item{stability_criterion}{Criterion for stability. Changes below this value
are no longer considered significant, and ten iterations without significant changes
to the energy level in succession will trigger the convergence check.}

\item{output}{Either \code{'qualitative'} (default), in which case the check
returns a boolean value representing whether it has passed or not, or
\code{'quantitative'}, in which case the number of checked trials for which
the convergence criterion was met is returned. This last option is of most
value for debugging convergence.}
}
\description{
This function applies the convergence criterion defined by McClelland and
Rumelhart to a given network, and returns either a (qualitative) boolean
value that represents the convergence state, or a (quantitative) value that
represents the number of iterations (of the last 10) that have met the
convergence threshold.
}
\details{
The check requires the following parameters:
}

