% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedGaussian.R
\name{as.MixedGaussian}
\alias{as.MixedGaussian}
\title{Convert a \code{GaussianPCM} model object to a \code{MixedGaussian} model object}
\usage{
as.MixedGaussian(o, modelTypes = NULL)
}
\arguments{
\item{o}{an R object: either a \code{GaussianPCM} or a \code{MixedGaussian}.}

\item{modelTypes}{NULL (the default) or a (possibly named) character string
vector. Each such string denotes a mixed Gaussian regime model class, e.g.
the result of calling \code{MGPMDefaultModelTypes()}. If specified, an
attempt is made to match the deduced Gaussian regime model type from \code{o}
with the elements of \code{modelTypes} and an error is raised if the match
fails. If the match succeeds the converted MixedGaussian object will have the
specified \code{modelTypes} parameter as an attribute \code{"modelTypes"}.}
}
\value{
a \code{MixedGaussian} object.
}
\description{
Convert a \code{GaussianPCM} model object to a \code{MixedGaussian} model object
}
\examples{
mg <- as.MixedGaussian(PCMBaseTestObjects$model.ab.123.bSigmae_x)
stopifnot(
  PCMLik(
    X = PCMBaseTestObjects$traits.ab.123,
    PCMBaseTestObjects$tree.ab,
    PCMBaseTestObjects$model.ab.123.bSigmae_x) ==
  PCMLik(
    X = PCMBaseTestObjects$traits.ab.123,
    PCMBaseTestObjects$tree.ab,
    mg))

}
