% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMLik}
\alias{PCMLik}
\title{Likelihood of a multivariate Gaussian phylogenetic comparative model with non-interacting lineages}
\usage{
PCMLik(
  X,
  tree,
  model,
  SE = matrix(0, PCMNumTraits(model), PCMTreeNumTips(tree)),
  metaI = PCMInfo(X = X, tree = tree, model = model, SE = SE, verbose = verbose),
  log = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and
\code{NaN} entries. For \code{i=1,..., N}, the column \code{i} of X contains
the measured trait values for species \code{i} (the tip with integer
identifier equal to \code{i} in \code{tree}). Missing values can be either
not-available (\code{NA}) or not existing (\code{NaN}). These two values are
treated differently when calculating likelihoods (see
\code{\link{PCMPresentCoordinates}}).}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{SE}{a k x N matrix specifying the standard error for each measurement in
X. Alternatively, a k x k x N cube specifying an upper triangular k x k
factor of the variance covariance matrix for the measurement error
for each tip \code{i=1, ..., N}. When \code{SE} is a matrix, the k x k
measurement error variance matrix for a tip \code{i} is calculated as
\code{VE[, , i] <- diag(SE[, i] * SE[, i], nrow = k)}. When \code{SE} is a
cube, the way how the measurement variance matrix for a tip \code{i} is
calculated depends on the runtime option \code{PCMBase.Transpose.Sigma_x}
as follows:
\describe{
\item{if \code{getOption("PCMBase.Transpose.Sigma_x", FALSE) == FALSE} (default): }{VE[, , i] <- SE[, , i] \%*\% t(SE[, , i])}
\item{if \code{getOption("PCMBase.Transpose.Sigma_x", FALSE) == TRUE}: }{VE[, , i] <- t(SE[, , i]) \%*\% SE[, , i]}
}
Note that the above behavior is consistent with the treatment of the model
parameters \code{Sigma_x}, \code{Sigmae_x} and \code{Sigmaj_x}, which are
also specified as upper triangular factors.
Default: \code{matrix(0.0, PCMNumTraits(model), PCMTreeNumTips(tree))}.}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model, SE)},
containing meta-data such as N, M and k. Alternatively, this can be a
character string naming a function or a function object that returns such
a list, e.g. the function\code{PCMInfo} or the function \code{PCMInfoCpp}
from the \code{PCMBaseCpp} package.}

\item{log}{logical indicating whether a log-likelehood should be calculated. Default
is TRUE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
a numerical value with named attributes as follows:
\describe{
\item{X0}{A numerical vector of length k specifying the value at the root for which
the likelihood value was calculated. If the model contains a member called X0, this
vector is used; otherwise the value of X0 maximizing the likelihood for the given
model parameters is calculated by maximizing the quadratic polynomial
'X0 * L_root * X0 + m_root * X0 + r_root';}
\item{error}{A character string with information if a numerical or other
logical error occurred during likelihood calculation.}
}
If an error occured during likelihood calculation, the default behavior is to
 return NA with a non-NULL error attribute. This behavior can be changed in
 using global options:
\describe{
 \item{"PCMBase.Value.NA"}{Allows to specify a different NA value such as \code{-Inf} or \code{-1e20} which can be used in combination with \code{log = TRUE} when
  using \code{optim} to maximize the log-likelihood;}
 \item{"PCMBase.Errors.As.Warnings"}{Setting this option to FALSE will cause any
 error to result in calling the \code{\link{stop}} R-base function. If not caught
 in a \code{\link{tryCatch}}, this will cause the inference procedure to abort at the occurence of a numerical error. By default, this option is set to TRUE, which
 means that \code{getOption("PCMBase.Value.NA", as.double(NA))} is returned with
 an error attribute and a warning is issued.}
}
}
\description{
The likelihood of a PCM represents the probability density function
  of observed trait values (data) at the tips of a tree given the tree and
  the model parameters. Seen as a function of the model parameters, the
  likelihood is used to fit the model to the observed trait data and the
  phylogenetic tree (which is typically inferred from another sort of data, such
  as an alignment of genetic sequences for the species at the tips of the tree).
  The \code{\link{PCMLik}} function
  provides a common interface for calculating the (log-)likelihood of different
  PCMs.
  Below we denote by N the number of tips, by M the total number of nodes in the
  tree including tips, internal and root node, and by k - the number of traits.
}
\details{
For efficiency, the argument \code{metaI}
  can be provided explicitly, because this is not supposed to change during a
  model inference procedure such as likelihood maximization.
}
\examples{
N <- 10
tr <- PCMTree(ape::rtree(N))

model <- PCMBaseTestObjects$model_MixedGaussian_ab

PCMTreeSetPartRegimes(tr, c(`11` = 'a'), setPartition = TRUE)

set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
X <- PCMSim(tr, model, X0 = rep(0, 3))

PCMLik(X, tr, model)
}
\seealso{
\code{\link{PCMInfo}} \code{\link{PCMAbCdEf}} \code{\link{PCMLmr}} \code{\link{PCMSim}} \code{\link{PCMCond}}
}
