% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates_and_times.R
\name{epoch_length_sec}
\alias{epoch_length_sec}
\title{Determine epoch length in seconds}
\usage{
epoch_length_sec(timestamps, digits = 6)
}
\arguments{
\item{timestamps}{POSIX-formatted input}

\item{digits}{for rounding. See details}
}
\value{
The epoch length of the data, in seconds
}
\description{
Determine epoch length in seconds
}
\details{
The function is designed to work even when the epoch length is less
  than one second (e.g., for raw accelerometry data). Thus, it is not
  possible to base the code on convenient \code{difftime} methods. Instead,
  numeric operations are performed after running \code{unclass} on the input.
  This sometimes results in minuscule fluctuations of the calculated epoch
  length (e.g., +/- 0.0000002). Thus, the code rounds everything to the
  precision indicated by \code{digits}. For most applications, the default
  value (\code{digits = 6}) should be well past the range of meaningful
  fluctuations and lead to a favorable outcome. But the \code{digits}
  argument can also be adjusted if greater assurance is needed.

  After rounding, the code checks for the existence of multiple epoch
  lengths. If they are detected (e.g., due to a discontinuity in the file), a
  warning is issued and the most prevalent epoch length is returned. The
  warning will specify all the different epoch lengths that were detected,
  which may be useful information for troubleshooting.
}
\examples{
epoch_length_sec(Sys.time() + 0:5)
epoch_length_sec(Sys.time() + seq(0, 25, 5))
}
