% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam.survreg.R
\name{pam.survreg}
\alias{pam.survreg}
\title{Prediction Accuracy Measures for Parametric Survival Regression Models}
\usage{
pam.survreg(fit.survreg)
}
\arguments{
\item{fit.survreg}{object inheriting from class survreg representing a fitted parametric survival
regression model. Specifying x = TRUE and y=TRUE are required in the call to survreg( )
to include the design matrix and the response vector in the object fit.}
}
\value{
A list containing two components: R-squared and L-squared
}
\description{
This function calculates a pair of measures, R-Squared and L-Squared, for parametric survival regression models. R-squared is an extension of the classical R2 statistic for a linear model, quantifying the amount of variability in the response that is explained by a corrected prediction based on the original prediction function. L-squared is the proportion of the prediction error of the original prediction function that is explained by the corrected prediction function, quantifying the distance between the corrected and uncorrected predictions. When used together, they give a complete summary of the predictive power of a prediction function.
}
\examples{
library(survival)
library(PAmeasures)

# Use Mayo Clinic Primary Biliary Cirrhosis Data
data(pbc)

head(pbc)

# Fit an exponential model with bilirubin
fit1 <- survreg(Surv(time, status==2) ~ bili, data = pbc,dist="exponential",x=TRUE,y=TRUE)

# R.squared and L.squared of exponential model
pam.survreg(fit1)

# Fit a lognormal model with standardised blood clotting time
fit2 <- survreg(Surv(time, status==2) ~ protime, data = pbc,dist="lognormal",x=TRUE,y=TRUE)

# R.squared and L.squared of lognormal model
pam.survreg(fit2)

# Fit a weibull model with bilirubin and standardised blood clotting time
fit3 <- survreg(Surv(time, status==2) ~ bili + protime, data = pbc,dist="weibull",x=TRUE,y=TRUE)

# R.squared and L.squared of weibull model
pam.survreg(fit3)
}
