#' Summarize Daily Physical Activity from 'SenseWear' Accelerometer Data
#'
#' Package PASenseWear allows you to summarize SenseWear physical activity data and to plot heat map from different perspectives.
#'
#'Function  \code{\link{Sensewear_report}} produces participant's daily activity report.
#'
#'Function \code{\link{heatmap}} plots heat map for a single participant. It shows the daily activity intensity change and makes it easy to compare activity intensity across different days.
#'
#'Function \code{\link{multipleheatmap}} gives the availability of grouping participants as user defined categories. The heat map illustrates different daily activity intensities of different groups.
#'
#' Sample datasets are provided for a referance of data format:
#'
#'  \code{\link{sampledata}} provides one participant's sample activity data.
#'
#'  \code{\link{sampledata_multiple}} provides 4 participants' combined sample activity data. An extra column ID helps to identify different participants.
#'
#'   \code{\link{demography}} records the age and gender of the above 4 participants for the use of plotting group heat map. Users can provide other demographic information for the corresponding useage in function \code{\link{multipleheatmap}}.
#'
#' @name PASenseWear
NULL
