% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{Schizo}
\alias{Schizo}
\title{Dopamine Activity}
\format{
A data frame with 15 observations on the following 2 variables:
\describe{ 
\item{nonpsychotic}{dopamine activity level for patients classified nonpsychotic} 
\item{psychotic}{dopamine activity level for patients classified psychotic} }
}
\source{
Sternberg, D. E., Van Kammen, D. P., and Bunney,W. E. (1982)
\dQuote{Schizophrenia: Dopamine b-Hydroxylase Activity and Treatment
Response.} \emph{Science}, \bold{216}: 1423-1425.
}
\description{
Twenty-five patients with schizophrenia were classified as psychotic or
nonpsychotic after being treated with an antipsychotic drug.  Samples of
cerebral fluid were taken from each patient and assayed for dopamine
b-hydroxylase (DBH) activity. The dopamine measurements for the two groups
are in nmol/(ml)(h)/(mg) of protein.
}
\examples{

with(data = Schizo, boxplot(nonpsychotic, psychotic,
names = c("nonpsychotic", "psychotic"), col = c("green", "red")))

}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\keyword{datasets}
