% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PANPRS_gsPEN.R
\name{gsPEN_R}
\alias{gsPEN_R}
\title{Run the gsPEN algorithm for multiple traits, without functional annotations.}
\usage{
gsPEN_R(
  summary_z,
  n_vec,
  plinkLD,
  n_iter = 100,
  upper_val = NULL,
  breaking = 1,
  z_scale = 1,
  tuning_matrix = NULL,
  tau_factor = c(1/25, 1, 10),
  len_lim_lambda = 10,
  sub_tuning = 50,
  lim_lambda = c(0.5, 0.9),
  len_lambda = 200,
  df_max = NULL,
  sparse_beta = FALSE,
  debug_output = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{summary_z}{A matrix of summary statistics for each SNP and trait.}

\item{n_vec}{A vector of sample sizes for each of the Q traits corresponding to the Q columns of summary_z.}

\item{plinkLD}{A matrix of LD values for each pair of SNPs.}

\item{n_iter}{The number of iterations to run the algorithm.}

\item{upper_val}{The upper bound for the tuning parameter.}

\item{breaking}{The number of iterations to run before checking for convergence.}

\item{z_scale}{The scaling factor for the summary statistics.}

\item{tuning_matrix}{A matrix of tuning parameters.}

\item{tau_factor}{A vector of factors to multiply the median value by to get the tuning parameters.}

\item{len_lim_lambda}{The number of tuning parameters to use for the first iteration.}

\item{sub_tuning}{The number of tuning parameters to use for the second iteration.}

\item{lim_lambda}{The range of tuning parameters to use for the first iteration.}

\item{len_lambda}{The number of tuning parameters to use for the second iteration.}

\item{df_max}{The maximum degrees of freedom for the model.}

\item{sparse_beta}{Whether to use the sparse version of the algorithm.}

\item{debug_output}{Whether to output the tuning combinations that did not converge.}

\item{verbose}{Whether to output information through the evaluation of the algorithm.}
}
\value{
A named list containing the following elements:
beta_matrix: A matrix of the estimated coefficients for each SNP and trait.
num_iter_vec: A vector of the number of iterations for each tuning combination.
all_tuning_matrix: A matrix of the tuning parameters used for each tuning combination.
}
\description{
Run the gsPEN algorithm for multiple traits, without functional annotations.
}
\examples{
# Load the library and data
library(PANPRSnext)
data("summaryZ")
data("Nvec")
data("plinkLD")

# Take random subset of the data
subset <- sample(nrow(summaryZ), 100)
subset_summary_z <- summaryZ[subset, ]

# Run gsPEN
output <- gsPEN_R(
  summary_z = subset_summary_z,
  n_vec = Nvec,
  plinkLD = plinkLD
)
}
