% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadPamguardXML.R
\name{loadPamguardXML}
\alias{loadPamguardXML}
\title{Load Pamguard XML Settings}
\usage{
loadPamguardXML(x)
}
\arguments{
\item{x}{an XML file created by Pamguard's "Export XML Configuration"}
}
\value{
A list with settings for audio \code{sources} (sound acuisition, decimators,
  FFT, and cepstrum) and \code{detectors} (click detector and whistle and moan
  detector). Also stores the entire XML file as \code{raw} and the file name as
  \code{file}
}
\description{
Loads in relevant settings and formats for use in PAMpal
}
\examples{

xmlFile <- system.file('extdata', 'Example.xml', package='PAMpal')
xmlList <- loadPamguardXML(xmlFile)
str(xmlList)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
