% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadOMLFlow.R
\name{uploadOMLFlow}
\alias{uploadOMLFlow}
\title{Upload an OpenML.}
\usage{
uploadOMLFlow(
  x,
  tags = NULL,
  verbosity = NULL,
  confirm.upload = NULL,
  sourcefile = NULL,
  binaryfile = NULL
)
}
\arguments{
\item{x}{[\code{\link{OMLFlow}}|\code{\link[mlr]{Learner}}]\cr
The flow that should be uploaded.}

\item{tags}{[\code{character}]\cr
The tags that should be added after uploading.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}

\item{confirm.upload}{[\code{logical(1)}]\cr
Should the user be asked to confirm the upload?
Default is the setting from your config.}

\item{sourcefile}{[\code{character(1)}]\cr
The file path to the flow (not needed for \code{\link[mlr]{Learner}}).}

\item{binaryfile}{[\code{character(1)}]\cr
The file path to the flow (not needed for \code{\link[mlr]{Learner}}).}
}
\value{
[\code{invisible(numeric)}].
  The ID of the flow (\code{flow.id}).
}
\description{
Share a flow by uploading it to the OpenML server.
}
\note{
This function will reset the cache of \code{\link{listOMLFlows}} on success.
}
\seealso{
Other uploading functions: 
\code{\link{makeOMLStudy}()},
\code{\link{uploadOMLDataSet}()},
\code{\link{uploadOMLRun}()},
\code{\link{uploadOMLStudy}()}
}
\concept{uploading functions}
