% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{validate_data}
\alias{validate_data}
\title{Validate data based on specified rules}
\usage{
validate_data(
  files_data,
  data_names = NULL,
  file_rules = NULL,
  zip_data = NULL
)
}
\arguments{
\item{files_data}{A list of file paths for the datasets to be validated.}

\item{data_names}{(Optional) A character vector of names for the datasets. If not provided, names will be extracted from the file paths.}

\item{file_rules}{A file path for the rules file, either in .csv or .xlsx format.}

\item{zip_data}{A file path to a zip folder for validating unstructured data.}
}
\value{
A list containing the following elements:
  - data_formatted: A list of data frames with the validated data.
  - data_names: A character vector of dataset names.
  - report: A list of validation report objects for each dataset.
  - results: A list of validation result data frames for each dataset.
  - rules: A list of validator objects for each dataset.
  - status: A character string indicating the overall validation status ("success" or "error").
  - issues: A logical vector indicating if there are any issues in the validation results.
  - message: A data.table containing information about any issues encountered.
}
\description{
Validate data based on specified rules
}
\examples{
# Validate data with specified rules
data("valid_example")
data("invalid_example")
data("test_rules")

result_valid <- validate_data(files_data = valid_example,
                        data_names = c("methodology", "particles", "samples"),
                        file_rules = test_rules)
                       
result_invalid <- validate_data(files_data = invalid_example,
                        data_names = c("methodology", "particles", "samples"),
                        file_rules = test_rules)

}
