% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{remote_share}
\alias{remote_share}
\title{Share your validated data}
\usage{
remote_share(
  validation,
  data_formatted,
  files,
  verified,
  valid_rules,
  valid_key_share,
  ckan_url,
  ckan_key,
  ckan_package,
  url_to_send,
  rules,
  results,
  s3_key_id,
  s3_secret_key,
  s3_region,
  s3_bucket,
  mongo_key,
  mongo_collection,
  old_cert = NULL
)
}
\arguments{
\item{validation}{A list containing validation information.}

\item{data_formatted}{A list containing formatted data.}

\item{files}{A vector of file paths to upload.}

\item{verified}{The secret key provided by the portal maintainer.}

\item{valid_rules}{A list of valid rules for the dataset.}

\item{valid_key_share}{A valid key to share data.}

\item{ckan_url}{The URL of the CKAN instance.}

\item{ckan_key}{The API key for the CKAN instance.}

\item{ckan_package}{The CKAN package to which the data will be uploaded.}

\item{url_to_send}{The URL to send the data.}

\item{rules}{A set of rules used for validation.}

\item{results}{A list containing results of the validation.}

\item{s3_key_id}{AWS ACCESS KEY ID}

\item{s3_secret_key}{AWS SECRET ACCESS KEY}

\item{s3_region}{AWS DEFAULT REGION}

\item{s3_bucket}{The name of the Amazon S3 bucket.}

\item{mongo_key}{mongo connection url}

\item{mongo_collection}{collection name}

\item{old_cert}{(Optional) An old certificate to be uploaded alongside the new one to override the previous submission with.}
}
\value{
A list containing the status and message of the operation.
}
\description{
This function uploads validated data to specified remote repositories,
such as CKAN, Amazon S3, and/or MongoDB.
}
\examples{
\dontrun{
shared_data <- remote_share(validation = result_valid,
                            data_formatted = result_valid$data_formatted,
                            files = test_file,
                            verified = "your_verified_key",
                            valid_key_share = "your_valid_key_share",
                            valid_rules = digest::digest(test_rules),
                            ckan_url = "https://example.com",
                            ckan_key = "your_ckan_key",
                            ckan_package = "your_ckan_package",
                            url_to_send = "https://your-url-to-send.com",
                            rules = test_rules,
                            results = valid_example$results,
                            s3_key_id = "your_s3_key_id",
                            s3_secret_key = "your_s3_secret_key",
                            s3_region = "your_s3_region",
                            s3_bucket = "your_s3_bucket",
                            mongo_key = "your_mongo_key",
                            mongo_collection = "your_mongo_collection",
                            old_cert = NULL
)
}
}
