% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{PlotHeat}
\alias{PlotHeat}
\title{Plot heatmap of the train set or test set}
\usage{
PlotHeat(object, set = "test", ...)
}
\arguments{
\item{object}{a SubtypeClass object}

\item{set}{options could be 'test', 'train' or 'both'. Default 'test'.}

\item{...}{Parameters passed to \code{pheatmap}.}
}
\value{
a pheatmap object
}
\description{
Plot heatmap of the train set or test set
}
\examples{
\dontrun{
library(OncoSubtype)
data <- get_median_centered(example_fpkm)
data <- assays(data)$centered
rownames(data) <- rowData(example_fpkm)$external_gene_name
object <- MLSubtype(data, disease = 'LUSC')
PlotHeat(object, set = 'both', fontsize = 10, show_rownames = FALSE, show_colnames = FALSE)
}
}
