\name(glmm}
\title{Generalized Linear Mixed Models}
\usage{
glmm(model, family=family, data=list(), weights=NULL, offset=NULL,
	nest, delta=1, maxiter=20, points=10, print.level=0,
	control=glm.control(epsilon=0.0001,maxit=10,trace=FALSE))
}
\arguments{
\item{model}{A symbolic description of the model to be fitted.}
\item{family}{A description of the error distribution and link
function to be used in the model; see \code{\link{family}} for details.}
\item{data}{An optional data frame containing the variables in
the model.}
\item{weights}{An optional weight vector. Data must be supplied in a
data.frame.}
\item{offset}{The known component in the linear predictor. Data must
be supplied in a data.frame. An offset cannot be specified in the
model formula.}
\item{nest}{The variable classifying observations by the unit
(cluster) upon which they were observed.}
\item{delta}{If the response variable has been transformed, this is
the Jacobian of that transformation, so that AICs are comparable.}
\item{maxiter}{The maximum number of iterations of the outer loop for
numerical integration.}
\item{points}{The number of points for Gauss-Hermite integration of
the random effect.}
\item{print.level}{If set equal to 2, the log probabilities are
printed out when the underflow error is given.}
\item{control}{A list of parameters for controlling the fitting
process.}
}
\description{
\code{glmm} fits a generalized linear mixed model with a random
intercept using a normal mixing distribution computed by Gauss-Hermite
integration. For the normal, gamma, and inverse Gaussian
distributions, the deviances supplied are -2 log likelihood, not the
usual \code{\link{glm}} deviance; the degrees of freedom take into
account estimation of the dispersion parameter.

If weights and/or offset are to be used, all of the data must be
supplied in a dataframe.

The following are not allowed, as compared to \code{\link{glm}}:
transformed variables in the formula, na.omit
}
\value{
\code{glmm} returns a list of class \code{glmm}
}
\seealso{
\code{\link{family}}, \code{\link{glm}}, \code{\link{glm.control}},
\code{\link{gnlmm}}, \code{\link{gnlr}}, \code{\link{gnlr3}},
\code{\link{fmr}}
}
