\name{diana.object}
\title{
Divisive Analysis Object
}
\section{GENERATION}{
This class of objects is returned from \code{diana}.


}
\section{METHODS}{
The \code{"diana"} class has methods for the following generic functions:
\code{print}, \code{summary}, \code{plot}, \code{pltree}.


}
\section{STRUCTURE}{
A legitimate \code{diana} object is a list with the following components:


}
\arguments{
\item{order}{
a vector giving a permutation of the original objects to allow for plotting,
in the sense that the branches of a clustering tree will not cross.


}
\item{height}{
a vector with the diameters of the clusters prior to splitting.


}
\item{dc}{
the divisive coefficient, measuring the clustering structure of the dataset.
For each object i, denote by d(i) the diameter of the last cluster to which
it belongs (before being split off as a single object), divided by the
diameter of the whole dataset.
The \code{dc} is the average of all 1 - d(i). It can also be seen as the average
width (or the percentage filled) of the banner plot.
Because \code{dc} grows with the number of objects, this measure should not
be used to compare datasets of very different sizes.


}
\item{merge}{
an (n-1) by 2 matrix, where n is the number of objects. Row i of \code{merge}
describes the split at step n-i of the clustering. If a number
j in row r is negative, then the single object |j| is split off at
stage n-r. If j is positive, then the cluster that will be splitted at
stage n-j (described by row j), is split off at stage n-r.


}}
\seealso{
\code{\link{diana}}, \code{\link{plot.diana}}, \code{\link{pltree.diana}}, \code{\link{agnes}}.


}
\keyword{all}
\keyword{cluster}
% Converted by Sd2Rd version 0.2-a3.
