Cmm This is the original adapt code with one modification.
Cmm Instead of calling the external function "FUNCTN", a fixed
Cmm external routine adphlp is always called, and passed a pointer
Cmm to the external S function.
Cmm     Michael Meyer, October 1989.

      SUBROUTINE ADAPT(NDIM,A,B,MINPTS,MAXPTS,FUNCTN,EPS,RELERR,LENWRK,
     * WRKSTR,FINEST,IFAIL)
C***BEGIN PROLOGUE ADAPT
C  ADAPTIVE MULTIDIMENSIONAL INTEGRATION SUBROUTINE
C           AUTHOR: A. C. GENZ, Washington State University
C                    19 March 1984
C**************  PARAMETERS FOR ADAPT  ********************************
C***** INPUT PARAMETERS
C  NDIM    NUMBER OF VARIABLES, MUST EXCEED 1, BUT NOT EXCEED 20
C  A       REAL ARRAY OF LOWER LIMITS, WITH DIMENSION NDIM
C  B       REAL ARRAY OF UPPER LIMITS, WITH DIMENSION NDIM
C  MINPTS  MINIMUM NUMBER OF FUNCTION EVALUATIONS TO BE ALLOWED.
C          ON THE FIRST CALL TO ADAPT MINPTS SHOULD BE SET TO A
C          NON NEGATIVE VALUE. (CAUTION... MINPTS IS ALTERED BY ADAPT)
C          IT IS POSSIBLE TO CONTINUE A CALCULATION TO GREATER ACCURACY
C          BY CALLING ADAPT AGAIN BY DECREASING EPS (DESCRIBED BELOW)
C          AND RESETTING MINPTS TO ANY NEGATIVE VALUE.
C          MINPTS MUST NOT EXCEED MAXPTS.
C  MAXPTS  MAXIMUM NUMBER OF FUNCTION EVALUATIONS TO BE ALLOWED,
C          WHICH MUST BE AT LEAST RULCLS, WHERE
C          RULCLS =  2**NDIM+2*NDIM**2+6*NDIM+1
C
C            FOR NDIM =  2   3   4   5   6   7   8   9   10
C            MAXPTS >=  25  45  73 113 173 269 433 729 1285
C         A suggested value for MAXPTS is 100 times the above values.
C
C  FUNCTN  EXTERNALLY DECLARED USER DEFINED FUNCTION TO BE INTEGRATED.
C          IT MUST HAVE PARAMETERS (NDIM,Z), WHERE Z IS A REAL ARRAY
C          OF DIMENSION NDIM.
C  EPS     REQUIRED RELATIVE ACCURACY
C  LENWRK  LENGTH OF ARRAY WRKSTR OF WORKING STORAGE, THE ROUTINE
C          NEEDS (2*NDIM+3)*(1+MAXPTS/RULCLS)/2 FOR LENWRK IF
C          MAXPTS FUNCTION CALLS ARE USED.
C          FOR GUIDANCE, IF YOU SET MAXPTS TO 100*RULCLS (SEE TABLE
C          ABOVE) THEN ACCEPTABLE VALUES FOR LENWRK ARE
C
C            FOR NDIM = 2    3    4    5    6    7    8     9
C            LENWRK =  357  561  1785 3417 6681 13209 26265 52377
C
C***** OUTPUT PARAMETERS
C  MINPTS  ACTUAL NUMBER OF FUNCTION EVALUATIONS USED BY ADAPT
C  WRKSTR  REAL ARRAY OF WORKING STORAGE OF DIMENSION (LENWRK).
C  RELERR  ESTIMATED RELATIVE ACCURACY OF FINEST
C  FINEST  ESTIMATED VALUE OF INTEGRAL
C  IFAIL   IFAIL=0 FOR NORMAL EXIT, WHEN ESTIMATED RELATIVE ACCURACY
C                  RELERR IS LESS THAN EPS WITH MAXPTS OR LESS FUNCTION
C                  CALLS MADE.
C          IFAIL=1 IF MAXPTS WAS TOO SMALL FOR ADAPT TO OBTAIN THE
C                  REQUIRED RELATIVE ACCURACY EPS.  IN THIS CASE ADAPT
C                  RETURNS A VALUE OF FINEST WITH ESTIMATED RELATIVE
C                  ACCURACY RELERR.
C          IFAIL=2 IF LENWRK TOO SMALL FOR MAXPTS FUNCTION CALLS.  IN
C                  THIS CASE ADAPT RETURNS A VALUE OF FINEST WITH
C                  ESTIMATED ACCURACY RELERR USING THE WORKING STORAGE
C                  AVAILABLE, BUT RELERR WILL BE GREATER THAN EPS.
C          IFAIL=3 IF NDIM ) 2, NDIM \ 20, MINPTS \ MAXPTS,
C                  OR MAXPTS ) RULCLS.
C***********************************************************************
C***END PROLOGUE ADAPT
cmmmc      EXTERNAL FUNCTN
ctslc	Real functn
        DOUBLE PRECISION functn
cmmmc
C*****  FOR DOUBLE PRECISION CHANGE REAL TO DOUBLE PRECISION IN THE
C        NEXT STATEMENT.
      DOUBLE PRECISION A(NDIM), B(NDIM), CENTER(20),
     * DIFMAX, EPS, ERRMIN, FINEST, HALF,
     * ONE, RELERR, RGNERR, RGNVAL,
     * TWO, WIDTH(20), WRKSTR(LENWRK), ZERO
      INTEGER DIVAXO, DIVAXN, DIVFLG, FUNCLS, IFAIL, INDEX1,
     * INDEX2, J, K, LENWRK, MAXCLS, MAXPTS, MINPTS, NDIM,
     * RGNSTR, RULCLS, SBRGNS, SBTMPP, SUBRGN, SUBTMP
      IFAIL=3
      RELERR=1
      FUNCLS=0
      IF(NDIM.LT.2.OR.NDIM.GT.20) GOTO 300
      IF(MINPTS.GT.MAXPTS) GOTO 300
C
C*****  INITIALISATION OF SUBROUTINE
C
      ZERO=0
      ONE=1
      TWO=2
      HALF=ONE/TWO
      RGNSTR=2*NDIM+3
      ERRMIN = ZERO
      MAXCLS =  2**NDIM+2*NDIM**2+6*NDIM+1
      MAXCLS = MIN0(MAXCLS,MAXPTS)
      DIVAXO=0
C
C*****  END SUBROUTINE INITIALISATION
      IF(MINPTS.LT.0) SBRGNS=WRKSTR(LENWRK-1)
      IF(MINPTS.LT.0) GOTO 280
      DO 30 J=1,NDIM
        WIDTH(J)=(B(J)-A(J))*HALF
   30   CENTER(J)=A(J)+WIDTH(J)
      FINEST=ZERO
      WRKSTR(LENWRK)=ZERO
      DIVFLG=1
      SUBRGN=RGNSTR
      SBRGNS=RGNSTR
   40 CALL BSRL(NDIM,CENTER,WIDTH,FUNCTN,MAXCLS,RULCLS,
     *            ERRMIN,RGNERR,RGNVAL,DIVAXO,DIVAXN)
      FINEST=FINEST+RGNVAL
      WRKSTR(LENWRK)=WRKSTR(LENWRK)+RGNERR
      FUNCLS = FUNCLS + RULCLS
C
C*****  PLACE RESULTS OF BASIC RULE INTO PARTIALLY ORDERED LIST
C*****  ACCORDING TO SUBREGION ERROR
      IF(DIVFLG.EQ.1) GO TO 230
C
C*****  WHEN DIVFLG=0 START AT TOP OF LIST AND MOVE DOWN LIST TREE TO
C       FIND CORRECT POSITION FOR RESULTS FROM FIRST HALF OF RECENTLY
C       DIVIDED SUBREGION
  200 SUBTMP=2*SUBRGN
      IF(SUBTMP.GT.SBRGNS) GO TO 250
       IF(SUBTMP.EQ.SBRGNS) GO TO 210
       SBTMPP=SUBTMP+RGNSTR
       IF(WRKSTR(SUBTMP).LT.WRKSTR(SBTMPP)) SUBTMP=SBTMPP
  210  IF(RGNERR.GE.WRKSTR(SUBTMP)) GO TO 250
        DO 220 K=1,RGNSTR
          INDEX1=SUBRGN-K+1
          INDEX2=SUBTMP-K+1
  220     WRKSTR(INDEX1)=WRKSTR(INDEX2)
        SUBRGN=SUBTMP
      GOTO 200
C
C*****  WHEN DIVFLG=1 START AT BOTTOM RIGHT BRANCH AND MOVE UP LIST
C       TREE TO FIND CORRECT POSITION FOR RESULTS FROM SECOND HALF OF
C       RECENTLY DIVIDED SUBREGION
  230 SUBTMP=(SUBRGN/(RGNSTR*2))*RGNSTR
      IF(SUBTMP.LT.RGNSTR) GO TO 250
      IF(RGNERR.LE.WRKSTR(SUBTMP)) GO TO 250
       DO 240 K=1,RGNSTR
         INDEX1=SUBRGN-K+1
         INDEX2=SUBTMP-K+1
  240    WRKSTR(INDEX1)=WRKSTR(INDEX2)
       SUBRGN=SUBTMP
      GOTO 230
C*****  STORE RESULTS OF BASIC RULE IN CORRECT POSITION IN LIST
  250 WRKSTR(SUBRGN)=RGNERR
      WRKSTR(SUBRGN-1)=RGNVAL
      WRKSTR(SUBRGN-2)=DIVAXN
      DO 260 J=1,NDIM
        SUBTMP=SUBRGN-2*(J+1)
        WRKSTR(SUBTMP+1)=CENTER(J)
  260   WRKSTR(SUBTMP)=WIDTH(J)
      IF(DIVFLG.EQ.1) GO TO 270
C*****  WHEN DIVFLG=0 PREPARE FOR SECOND APPLICATION OF BASIC RULE
      CENTER(DIVAXO)=CENTER(DIVAXO)+TWO*WIDTH(DIVAXO)
      SBRGNS=SBRGNS+RGNSTR
      SUBRGN=SBRGNS
      DIVFLG=1
C*****  LOOP BACK TO APPLY BASIC RULE TO OTHER HALF OF SUBREGION
      GO TO 40
C
C*****  END ORDERING AND STORAGE OF BASIC RULE RESULTS
C*****  MAKE CHECKS FOR POSSIBLE TERMINATION OF ROUTINE
C
C******  FOR DOUBLE PRECISION CHANGE ABS TO DABS IN THE NEXT STATEMENT
  270 RELERR=ONE
      IF(WRKSTR(LENWRK).LE.ZERO) WRKSTR(LENWRK)=ZERO
      IF(ABS(FINEST).NE.ZERO) RELERR=WRKSTR(LENWRK)/ABS(FINEST)
      IF(RELERR.GT.ONE) RELERR=ONE
      IF(SBRGNS+RGNSTR.GT.LENWRK-2) IFAIL=2
      IF(FUNCLS+FUNCLS*RGNSTR/SBRGNS.GT.MAXPTS) IFAIL=1
      IF(RELERR.LT.EPS.AND.FUNCLS.GE.MINPTS) IFAIL=0
      IF(IFAIL.LT.3) GOTO 300
C
C*****  PREPARE TO USE BASIC RULE ON EACH HALF OF SUBREGION WITH LARGEST
C       ERROR
  280 DIVFLG=0
      SUBRGN=RGNSTR
      SUBTMP = 2*SBRGNS/RGNSTR
      MAXCLS = MAXPTS/SUBTMP
      ERRMIN = ABS(FINEST)*EPS/FLOAT(SUBTMP)
      WRKSTR(LENWRK)=WRKSTR(LENWRK)-WRKSTR(SUBRGN)
      FINEST=FINEST-WRKSTR(SUBRGN-1)
      DIVAXO=WRKSTR(SUBRGN-2)
      DO 290 J=1,NDIM
        SUBTMP=SUBRGN-2*(J+1)
        CENTER(J)=WRKSTR(SUBTMP+1)
  290   WIDTH(J)=WRKSTR(SUBTMP)
      WIDTH(DIVAXO)=WIDTH(DIVAXO)*HALF
      CENTER(DIVAXO)=CENTER(DIVAXO)-WIDTH(DIVAXO)
C
C*****  LOOP BACK TO APPLY BASIC RULE
C
      GOTO 40
C
C*****  TERMINATION POINT
C
  300 MINPTS=FUNCLS
      WRKSTR(LENWRK-1)=SBRGNS
      RETURN
      END
