/* gee support @(#) VC_GEE_diag_as_vec.c 3.3 94/03/09 */

#include "chanmat.h"
#include<setjmp.h>

jmp_buf env;

MATRIX *VC_GEE_diag_as_vec(inmat)
MATRIX *inmat;
{
  int i;
  MATRIX *outmat;

  if(inmat->ncols!=inmat->nrows)
    {
      fprintf(stderr,"M+-: VC_GEE_diag_as_vec: arg is not a square matrix. Dies.\n");
      fprintf(stderr,"\nNumber of columns = %d",inmat->ncols);
      fprintf(stderr,"\nNumber of rows    = %d\n",inmat->nrows);
      Seterr_and_terminate(DIAG_AS_VEC_ARG_BAD);
    }

  outmat= VC_GEE_create_matrix(inmat->nrows,1,EPHEMERAL);
  for(i= 0;i<inmat->nrows;i++)
    {
      *(ELREF(outmat,i,0))=  *(ELREF(inmat,i,i));
    }
  return outmat;
}



MATRIX *VC_GEE_matsqrt(x)
MATRIX *x;
{
  int i,j;
  MATRIX *tmp;
  tmp= VC_GEE_matcopy(x);
  for(i= 0;i<x->ncols;i++)
    {
      for(j= 0;j<x->nrows;j++)
	{
	  MEL(tmp,i,j)= sqrt(MEL(x,i,j));
	}
    }
  if(is_ephemeral(x))VC_GEE_destroy_matrix(x);
  return tmp;
}

MATRIX *VC_GEE_mat1over(x)
MATRIX *x;
{
  int i,j;
  MATRIX *tmp;
  tmp= VC_GEE_matcopy(x);
  for(i=0;i<x->ncols;i++)
    {
      for(j=0;j<x->nrows;j++)
	{
	  MEL(tmp,i,j)= 1./(MEL(x,i,j));
	}
    }
  if(is_ephemeral(x))VC_GEE_destroy_matrix(x);
  return tmp;
}
