% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ohit.R
\name{Ohit}
\alias{Ohit}
\title{Fit a high-dimensional linear regression model via OGA+HDIC+Trim}
\usage{
Ohit(X, y, Kn = NULL, c1 = 5, HDIC_Type = "HDBIC", c2 = 2, c3 = 2.01,
  intercept = TRUE)
}
\arguments{
\item{X}{Input matrix of \code{n} rows and \code{p} columns.}

\item{y}{Response vector of length \code{n}.}

\item{Kn}{The number of OGA iterations. \code{Kn} must be a positive integer between \code{1} and \code{p}. Default is \code{Kn=max(1, min(floor(c1}*\code{sqrt(n/log(p))), p))}, where \code{c1} is a tuning parameter.}

\item{c1}{The tuning parameter for the number of OGA iterations. Default is \code{c1=5}.}

\item{HDIC_Type}{High-dimensional information criterion. The value must be \code{"HDAIC"}, \code{"HDBIC"} or \code{"HDHQ"}. The formula is \code{n}*\code{log(rmse)+k_use}*\code{omega_n}*\code{log(p)} where \code{rmse} is the residual mean squared error and \code{k_use} is the number of variables used to fit the model. For \code{HDIC_Type="HDAIC"}, it is HDIC with \code{omega_n=c2}. For \code{HDIC_Type="HDBIC"}, it is HDIC with \code{omega_n=log(n)}. For \code{HDIC_Type="HDHQ"}, it is HDIC with \code{omega_n=c3}*\code{log(log(n))}. Default is \code{HDIC_Type="HDBIC"}.}

\item{c2}{The tuning parameter for \code{HDIC_Type="HDAIC"}. Default is \code{c2=2}.}

\item{c3}{The tuning parameter for \code{HDIC_Type="HDHQ"}. Default is \code{c3=2.01}.}

\item{intercept}{Should an intercept be fitted? Default is \code{intercept=TRUE}.}
}
\value{
\item{n}{The number of observations.}

\item{p}{The number of input variables.}

\item{Kn}{The number of OGA iterations.}

\item{J_OGA}{The index set of Kn variables sequencially selected by OGA.}

\item{HDIC}{The HDIC values along the OGA path.}

\item{J_HDIC}{The index set of valuables determined by OGA+HDIC.}

\item{J_Trim}{The index set of valuables determined by OGA+HDIC+Trim.}

\item{betahat_HDIC}{The estimated regression coefficients of the model determined by OGA+HDIC.}

\item{betahat_Trim}{The estimated regression coefficients of the model determined by OGA+HDIC+Trim.}
}
\description{
The first step is to sequentially select input variables via orthogonal greedy algorithm (OGA). The second step is to determine the number of OGA iterations using high-dimensional information criterion (HDIC). The third step is to remove irrelevant variables remaining in the second step using HDIC.
}
\examples{
# Example setup (Example 3 in Section 5 of Ing and Lai (2011))
n = 400
p = 4000
q = 10
beta_1q = c(3, 3.75, 4.5, 5.25, 6, 6.75, 7.5, 8.25, 9, 9.75)
b = sqrt(3/(4 * q))

x_relevant = matrix(rnorm(n * q), n, q)
d = matrix(rnorm(n * (p - q), 0, 0.5), n, p - q)
x_relevant_sum = apply(x_relevant, 1, sum)
x_irrelevant = apply(d, 2, function(a) a + b * x_relevant_sum)
X = cbind(x_relevant, x_irrelevant)
epsilon = rnorm(n)
y = as.vector((x_relevant \%*\% beta_1q) + epsilon)

# Fit a high-dimensional linear regression model via OGA+HDIC+Trim
Ohit(X, y, intercept = FALSE)
}
\references{
Ing, C.-K. and Lai, T. L. (2011). A stepwise regression method and consistent model selection for high-dimensional sparse linear models. \emph{Statistica Sinica}, \strong{21}, 1473--1513.
}
\author{
Hai-Tang Chiou, Ching-Kang Ing and Tze Leung Lai.
}
