% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pseudo_Generics.R
\name{compendium_reference}
\alias{compendium_reference}
\title{Consult the
\href{https://sites.google.com/site/compendiumofphysicalactivities/}{Compendium
of Physical Activities} to Encode Direct Observation Intensities}
\usage{
compendium_reference(obs_data, interactive = TRUE, ...)
}
\arguments{
\item{obs_data}{A data frame outputted from
\code{\link{data_collection_program}}}

\item{interactive}{Logical. Should program be run interactively?}

\item{...}{Additional arguments passed to method-like functions (under "See Also" below)}
}
\value{
A data frame fully annotated with intensity values
}
\description{
Consult the
\href{https://sites.google.com/site/compendiumofphysicalactivities/}{Compendium
of Physical Activities} to Encode Direct Observation Intensities
}
\note{
If `interactive = TRUE`, but R is not being used interactively, a
  message is issued and an override is implemented to set `interactive =
  FALSE`.
}
\examples{
data(example_data)

compendium_reference(example_data, FALSE, kids = "yes", mvpa = "yes")
if (interactive()) {
    compendium_reference(example_data)
}

}
\seealso{
Other processing functions: 
\code{\link{interactive_compendium_reference}()},
\code{\link{manual_compendium_reference}()}
}
\concept{processing functions}
