% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{eff}
\alias{eff}
\alias{eff.default}
\alias{eff.dropout}
\alias{eff.proportional}
\alias{eff.interference}
\title{Efficiency generic function}
\usage{
eff(exact_design, ex = NULL)

\method{eff}{default}(exact_design, ex = NULL)

\method{eff}{dropout}(exact_design, ex = NULL)

\method{eff}{proportional}(exact_design, ex = NULL)

\method{eff}{interference}(exact_design, ex = NULL)
}
\arguments{
\item{exact_design}{A S3 object returned by \code{design} function.}

\item{ex}{Matrix. Design to be compared to. Default is \code{NULL}.}
}
\value{
Numeric. Relative Efficiency.
    If \code{ex} is given, return relative efficiency by \eqn{\Phi_{example}/\Phi_{exact\_design}};
    If \code{ex} is missing, return relative efficiency by \eqn{\Phi_{approx\_design}/\Phi_{exact\_design}}.
}
\description{
A generic function that returns the efficiency for either exact designs to approximate
designs or exact design to a given design
}
\seealso{
see examples in \link{design}.
}
