test_that("OVL_derivates_1 returns a list with 7 derivatives", {
  OVL_mix_dummy <- function(mu1, mu2, sigma1, sigma2, pi1, pi2, intersec) 0

  out <- OVL_derivates_1(
    mu1_hat = 0,
    mu2_hat = c(-1, 1),
    sigma1_hat = 1,
    sigma2_hat = c(1, 1),
    pi2_hat = 0.4,
    h = 1e-6,
    intersec = c(-0.5, 0.5),
    OVL_mix = OVL_mix_dummy
  )

  expect_true(is.list(out))
  expect_length(out, 7)
})

test_that("OVL_derivates_2 returns a list with 10 derivatives", {
  OVL_mix_dummy <- function(mu1, mu2, sigma1, sigma2, pi1, pi2, intersec) 0

  out <- OVL_derivates_2(
    mu1_hat = c(-1, 1),
    mu2_hat = c(0, 2),
    sigma1_hat = c(1, 1),
    sigma2_hat = c(1, 1),
    pi1_hat = 0.6,
    pi2_hat = 0.4,
    h = 1e-6,
    intersec = c(-0.2, 0.2),
    OVL_mix = OVL_mix_dummy
  )

  expect_true(is.list(out))
  expect_length(out, 10)
})
