#' Estimates the density function using the Gaussian kernel.
#' @param data vector of observations.
#' @param points in which the function is evaluated.
#' @param h bandwidth.
#' @return density estimation.
#' @keywords internal
kernel.g.density <- function(data,points,h){
ndata <- length(data)
npoints <- length(points)
matk <- kernel.g((points%*%t(rep(1,ndata))-t(data%*%t(rep(1,npoints))))/h)
as.vector((matk%*%rep(1,ndata))/(ndata*h))
}
