% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinityMatrix.R
\name{affinityMatrix}
\alias{affinityMatrix}
\title{Calculate the similarity matrix}
\usage{
affinityMatrix(Diff, K = 20, sigma = 0.5)
}
\arguments{
\item{Diff}{The distance matrix to culculate the similarity}

\item{K}{The number of neighbours to culculate the similarity}

\item{sigma}{A hyper-parameter to culculate the similarity}
}
\value{
The similarity matrix
}
\description{
To calculate the similarity matrix with the same method in package M2SMF, for asymmetric case
}
\examples{

data1 <- matrix(0,100,100)
data2 <- matrix(0,80,100)
for (i in 1:20)
{
  data1[i,] <- rnorm(100,10,1)
}
for (i in 21:40)
{
  data1[i,] <- rnorm(100,20,1)
}
for (i in 41:60)
{
  data1[i,] <- rnorm(100,30,1)
}
for (i in 61:80)
{
  data1[i,] <- rnorm(100,40,1)
}
for (i in 81:100)
{
  data1[i,] <- rnorm(100,50,1)
}
for (i in 1:20)
{
  data2[i,] <- rnorm(100,5,1)
}
for (i in 21:40)
{
  data2[i,] <- rnorm(100,10,1)
}
for (i in 41:60)
{
  data2[i,] <- rnorm(100,15,1)
}
for (i in 61:80)
{
  data2[i,] <- rnorm(100,20,1)
}
new_data1 <- Standard_Normalization(data1)
new_data2 <- Standard_Normalization(data2)
Diff <- dist2eu(new_data1,new_data2)
simi_matr1 <- affinityMatrix(Diff, K = 20, sigma = 0.5)
}
\author{
Xiaoyao Yin
}
