% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSLdecomposition-package.R
\docType{package}
\name{OSLdecomposition-package}
\alias{OSLdecomposition-package}
\alias{OSLdecomposition}
\title{Signal Component Analysis for Optically Stimulated Luminescence}
\description{
Function library for the identification and separation of exponentially
decaying signal components in continuous-wave optically stimulated luminescence (CW-OSL) measurements.
A special emphasis is laid on luminescence dating with quartz, which is known for
systematic errors due to CW-OSL signal components with unequal physical behaviour.
Also, this package enables an easy to use signal decomposition of
CW-OSL data sets imported and analysed with the R package 'Luminescence'.
This includes the optional automatic creation of HTML reports.
}
\details{
\strong{Project website}
\itemize{
\item \url{https://luminescence.de}
}

\strong{Source code repository}
\itemize{
\item \url{https://github.com/DirkMittelstrass/OSLdecomposition}
}

\strong{Bug reporting}
\itemize{
\item \url{https://github.com/DirkMittelstrass/OSLdecomposition/issues}
}

\strong{This package is part of the RLum.Network}
\itemize{
\item \url{https://r-luminescence.org}
}

\strong{Package maintainer}

Dirk Mittelstraß, Independent researcher, Dresden (Germany),\cr
\email{dirk.mittelstrass@luminescence.de}

\strong{Citation}

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.

\strong{Funding}
Dirk Mittelstraß created this package as part of his master thesis and further enhanced and
published it as private endeavour. He did not receive any specific grant from funding agencies
in the public, commercial or not-for-profit sectors.
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/DirkMittelstrass/OSLdecomposition/issues}
}

}
\author{
\strong{Maintainer}: Dirk Mittelstraß \email{dirk.mittelstrass@luminescence.de} (\href{https://orcid.org/0000-0002-9567-8791}{ORCID})

Authors:
\itemize{
  \item Sebastian Kreutzer (\href{https://orcid.org/0000-0002-0734-2199}{ORCID})
  \item Christoph Schmidt (\href{https://orcid.org/0000-0002-2309-3209}{ORCID})
}

Other contributors:
\itemize{
  \item Jan Beyer (\href{https://orcid.org/0000-0002-1403-395X}{ORCID}) [thesis advisor]
  \item Johannes Heitmann [thesis advisor]
  \item Arno Straessner (\href{https://orcid.org/0000-0003-2460-6659}{ORCID}) [thesis advisor]
}

}
\keyword{package}
