% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Groupwise}
\alias{plot.Groupwise}
\title{Heatmap of a Groupwise Object}
\usage{
\method{plot}{Groupwise}(
  x = NULL,
  class.sort = "",
  row.sort = "sens",
  main = "groupwise",
  xlab = "classes",
  ylab = "cascades",
  digits = 3,
  ignore = 0,
  casc.colors = c("#f5f5f5", "#01665e"),
  na.color = c("#f5f5f5"),
  color.key = TRUE,
  las = 1,
  cex = 1,
  cex.lab = 1,
  srt = 30,
  ...
)
}
\arguments{
\item{x}{A Groupwise object as it is returned by \code{\link{groupwise}}-function.}

\item{class.sort}{The classes can be sorted either according to the first cascade in the Groupwise object (''), 
or based on the class frequency ('max').}

\item{row.sort}{The cascade can be sorted either based on the maximal-minimal class-wise sensitivity ('sens') or 
according the class frequency.}

\item{main}{See \code{\link{plot}}.}

\item{xlab}{A title for the x axis (see \code{\link{plot}}).}

\item{ylab}{A title for the y axis (see \code{\link{plot}}).}

\item{digits}{Integer indicating the number of decimal places to be used (see \code{\link{round}}).}

\item{ignore}{A numeric value between 0 and 1. 
All confusion and purity values below this number are not written as string into the corresponding element.}

\item{casc.colors}{A 2-element vector of the color for the minimal and maximal class-wise sensitivity. 
The color palette is calcuated by an interpolation between the 2 given colors.}

\item{na.color}{Color, which is used for indicating the empty elements (if the given class is not part of the cascade).}

\item{color.key}{Specifies whether a color key is drawn (TRUE) or not (FALSE).}

\item{las}{See \code{\link{par}}.}

\item{cex}{See \code{\link{par}}.}

\item{cex.lab}{See \code{\link{par}}.}

\item{srt}{Angle used to rotate the strings of the x-axis and y-axis labels (see \code{\link{par}}).}

\item{...}{Further arguments passed from other methods.}
}
\value{
No return value, called to generate the heatmap plot of the Groupwise Object.
}
\description{
Plots a heatmap, that shows the performance of cascades of a Groupwise object.
}
\details{
This function plots a heatmap with the cascades of the Groupwise object in the rows 
and all classes present in any of the cascades in the columns. 
The colors indicate whether a given class is present in the corresponding cascade and with which sensitivity.
Internally converts the Groupwise object to a Subcascades object and plots the corresponding heatmap.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap <- predictionMap(data, labels, foldList = foldList, 
                        classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subc <- subcascades(predMap,thresh=0.7,size=c(3,4))
groupwise <- groupwise(subc)

plot(groupwise,row.sort='max')

}
\seealso{
\code{\link{groupwise}}, \code{\link{subcascades}}, \code{\link{plot.Subcascades}}
}
