% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPTtesting.R
\name{FDP_compute}
\alias{FDP_compute}
\title{FDP_compute}
\usage{
FDP_compute(decision, ui, positive)
}
\arguments{
\item{decision}{returns from the function Optimal_procedure_3}

\item{ui}{true mean vector}

\item{positive}{TRUE/FALSE valued. TRUE: H0: ui no greater than 0.  FALSE: H0: ui no less than 0.}
}
\value{
False discovery proportion (FDP) and False non-discovery proportion (FNP)
}
\description{
False discovery proportion and False non-discovery proportion computation
}
\examples{
ui = rnorm(10,0,1) #assume this is true parameter
decision = rbinom(10,1, 0.4) #assume this is decision vector
FDP_compute(decision,ui,TRUE)
\donttest{
library(MASS)
######################################
#construct a test statistic vector Z
p = 1000
n_col = 4
pi_0 = 0.6
pi_1 = 0.2
pi_2 = 0.2
nu_0 = 0
mu_1 = -1.5
mu_2 = 1.5
tau_sqr_1 = 0.1
tau_sqr_2 = 0.1


A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix




b = rmultinom(p, size = 1, prob = c(pi_0,pi_1,pi_2))
ui = b[1,]*nu_0 + b[2,]*rnorm(p, mean = mu_1,
     sd = sqrt(tau_sqr_1)) + b[3,]*rnorm(p, mean = mu_2,
      sd = sqrt(tau_sqr_2)) # actual situation
Z = mvrnorm(n = 1,ui, Sigma, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)

prob_p = d_value(Z,Sigma)
#decision
level = 0.1 #significance level
decision_p = Optimal_procedure_3(prob_p,level)
FDP_compute(decision_p$ai,ui,TRUE)
}
}
