% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPTtesting.R
\name{AEB}
\alias{AEB}
\title{AEB}
\usage{
AEB(
  Z,
  Sigma,
  eig = eigs_sym(Sigma, min(400, length(Z)), which = "LM"),
  eig_tol = 1,
  set_nu = c(0),
  set1 = c(0:10) * 0.01 + 0.01,
  set2 = c(0:10) * 0.01 + 0.01,
  setp = c(1:7) * 0.1
)
}
\arguments{
\item{Z}{a vector of test statistics}

\item{Sigma}{covariance matrix}

\item{eig}{eig value information}

\item{eig_tol}{the smallest eigen value used in the calulation}

\item{set_nu}{a search region for nu_0}

\item{set1}{a search region for tau_sqr_1}

\item{set2}{a search region for tau_sqr_2}

\item{setp}{a search region for proportion}
}
\value{
The return of the function is a list
in the form of list(nu_0, tau_sqr_1, tau_sqr_2, pi_0, pi_1, pi_2, mu_1, mu_2, Z_hat).

nu_0, tau_sqr_1, tau_sqr_2: The best combination of \eqn{(\nu_0, \tau_1^2, \tau_2^2)} that minimize the total variance from the regions \eqn{(D_{\nu_0}, D_{\tau_1^2}, D_{\tau_2^2})}.

pi_0, pi_1, pi_2, mu_1, mu_2: The estimates of parameters \eqn{\pi_0, \pi_1, \pi_2, \mu_1, \mu_2}.

Z_hat: A vector of simulated data  base on the parameter estimates.
}
\description{
Estimate the parameters in the three-part mixture
}
\details{
Estimate the parameters in the three-part mixture \eqn{Z|\mu ~ N_p(\mu,\Sigma )}
where \eqn{\mu_i ~ \pi_0 \delta_ {\nu_0} + \pi_1  N(\mu_1, \tau_1^2)  + \pi_2  N(\mu_2, \tau_2^2), i = 1, ..., p}
}
\examples{
p = 500
 n_col = 10
A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix
Z = rnorm(p,0,1) #this is just an example for testing the algorithm.
#Not true test statistics with respect to Sigma
best_set =  AEB(Z,Sigma)
print(c(best_set$pi_0, best_set$pi_1, best_set$pi_2, best_set$mu_1, best_set$mu_2))
\donttest{
library(MASS)
######################################
#construct a test statistic vector Z
p = 1000
n_col = 4
pi_0 = 0.6
pi_1 = 0.2
pi_2 = 0.2
nu_0 = 0
mu_1 = -1.5
mu_2 = 1.5
tau_sqr_1 = 0.1
tau_sqr_2 = 0.1


A = matrix(rnorm(p*n_col,0,1), nrow = p, ncol = n_col, byrow = TRUE)
Sigma = A \%*\% t(A) +diag(p)
Sigma = cov2cor(Sigma) #covariance matrix




b = rmultinom(p, size = 1, prob = c(pi_0,pi_1,pi_2))
ui = b[1,]*nu_0 + b[2,]*rnorm(p, mean = mu_1,
     sd = sqrt(tau_sqr_1)) + b[3,]*rnorm(p, mean = mu_2,
      sd = sqrt(tau_sqr_2)) # actual situation
Z = mvrnorm(n = 1,ui, Sigma, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)

best_set =AEB(Z,Sigma)
print(c(best_set$pi_0, best_set$pi_1, best_set$pi_2, best_set$mu_1, best_set$mu_2))
}
}
