% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{test.once.psi}
\alias{test.once.psi}
\title{test single change point for matrix-valued online data given rolling
eigenvalue series}
\usage{
test.once.psi(m = 20, psi, method = "ps", eta = 0.25, cv = 2.386)
}
\arguments{
\item{m}{a positive integer (\eqn{>1}) indicating the bandwidth of the
rolling windom.}

\item{psi}{the transformed eigenvalue series, produced by gen.psi.tau.flat
or gen.psi.tau.proj, with length \eqn{T-m}.}

\item{method}{indicating the test statistic, ``ps'' for the partial-sum
method, while others for the worst-case method.}

\item{eta}{a number between \eqn{[0,1)}, indicating the parameter \eqn{\eta}
used in the partial-sum statistic.}

\item{cv}{critical value, related to the significance level and test
statistic. The default cv is from Horvath et al. (2004), and only works for
\eqn{\eta=0.25} or \eqn{\eta=0.75}. For other cases, generate the critical
value first by function \code{\link{getcv}}. Note that for the partial-sum
statistic with \eqn{\eta} not equal to 0.5, the critical values are
approximated by simulated data, thus can be slightly different from those in
Horvath et al. (2004).}
}
\value{
a list containing:
\item{test}{a logical value. 1 indicating the existence of change point, 0
indicating no change point.}
\item{loc}{an integer larger than m, indicating
the location of change point; or \eqn{NA} when no change point is reported.}
}
\description{
This function tests single change point for matrix-valued online time
series, under a two-way factor structure, given the transformed eigenvalue
series.
}
\details{
See He et al. (2021).
}
\examples{

k1=3
k2=3
epsilon=0.05
Sample_T=50
p1=40
p2=20
kmax=8
r=8
m=p2

# generate data
Y=gen.data(Sample_T,p1,p2,k1,k2,tau=0.5,change=1,pp=0.5)

# calculate delta
temp=log(p1)/log(m*p2)
delta=epsilon*(temp<=0.5)+(epsilon+1-1/(2*temp))*(temp>0.5)

# calculate psi.tau
psi1=gen.psi.tau.proj(Y,k1+1,m,delta,r,kmax)
psi2=gen.psi.tau.flat(Y,k1+1,m,delta,r)

# calculate cv for "ps" with eta=0.45 and "wc"
cv1=getcv(0.05,method="ps",eta=0.45)
cv2=getcv(0.05,method="wc")


# test with psi1
test.once.psi(m,psi1[,3],method="ps",eta=0.45,cv1)

test.once.psi(m,psi1[,3],method="wc",eta=0.5,cv2)


# test with psi2
test.once.psi(m,psi2[,3],method="ps",eta=0.45,cv1)

test.once.psi(m,psi2[,3],method="wc",eta=0.5,cv2)


}
\references{
Horvath L, Huskova M, Kokoszka P, et al (2004). Monitoring
changes in linear models. \emph{Journal of statistical Planning and
Inference}, 126(1): 225-251.

He Y, Kong X, Trapani L, & Yu L(2021). Online change-point detection for
matrix-valued time series with latent two-way factor structure. \emph{arXiv
preprint}, arXiv:2112.13479.
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
