% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogi.R
\name{cov2weight}
\alias{cov2weight}
\title{Weight Vectors of the Bi-unit Canonical Form}
\usage{
cov2weight(S, Dvec = rep(1, nrow(S)), nu = rep(1, nrow(S)), tol = 1e-06,
  force = FALSE)
}
\arguments{
\item{S}{Covariance matrix, especially it is positive semi-definite.}

\item{Dvec}{Numeric vector of initial values of iteration.}

\item{nu}{Numeric vector of subjective importance. It determines the
importance of each of the variates.}

\item{tol}{Numeric number of tolerance. If the minimum eigenvalue of \code{S}
is less than \code{tol}, \code{S} is considered not to be positive
definite.}

\item{force}{Logical: if force=FALSE, \code{S} should be strictly positive
definite. Default: FALSE.}
}
\value{
Numeric vector of diagonal elements of \eqn{D}, which appears in the
  bi-unit canonical form \eqn{DSD} of \eqn{S}.
}
\description{
\code{cov2weight(S)} returns the numeric vector in which the diagonal
elements of the matrix \eqn{D} are arranged, where \eqn{DSD} is the bi-unit
canonical form of \eqn{S}.
}
\examples{
S = matrix(0, 5, 5)
S[1,1] = 1
for(j in 2:5) S[1,j] = S[j,1] = -0.5
for(i in 2:5){
  for(j in 2:5){
    if(i == j) S[i,j] = 1
    else S[i,j] = 0.5
  }
}
weight=cov2weight(S)
weight
}
