% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querying.R
\name{to_odata}
\alias{to_odata}
\alias{to_odata_}
\title{Macro to convert R to OData syntax}
\usage{
to_odata(expr)

to_odata_(expr)
}
\arguments{
\item{expr}{Expression to convert to OData}
}
\description{
Macro to convert R to OData syntax
}
\details{
to_odata takes unquote R code and quotes its input. Use !! to unquote an argument.
to_odata_ requires its argument to be quoted already.

Only a subset of R is supported.

* arithmatic
The operators +, -, *, / and %% are mapped to add, sub, mul, divby and mod respectively

* strings (characters in R)
toupper, tolower, startsWith, endsWith, nchar, paste, paste0, trimws

* arrays (lists in R)
list, append, length

* Formulae become lambdas in OData
(x ~ x$Name == "John")

Every unknown function is passed as is.
If the function name is surrounded by percent signs it's treated as an infix operator.
}
\examples{
to_odata(Field == value)
address <- "Bakerstreet 4"
to_odata(!!address \%in\% Adresses)
to_odata(Friends$any(f ~ f$FirstName == 'John'))

}
