% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{retrieve_all}
\alias{retrieve_all}
\title{Retrieve data. If data is paged, concatenate pages.
Only return the value without metadata.}
\usage{
retrieve_all(url, ...)
}
\arguments{
\item{url}{Which url to fetch data from}

\item{...}{
  Arguments passed on to \code{\link[=retrieve_data]{retrieve_data}}
  \describe{
    \item{\code{metadata}}{Whether and how metadata is included}
    \item{\code{httr_args}}{List of additional arguments passed on to httr::GET}
    \item{\code{jsonlite_args}}{List of additional arguments passed on to jsonlite::fromJSON}
  }}
}
\description{
Retrieve data. If data is paged, concatenate pages.
Only return the value without metadata.
}
\examples{
\dontrun{
url <- "https://services.odata.org/V4/TripPinServiceRW/People"
retrieve_all(url)
}
}
\seealso{
Other retrieve: 
\code{\link{odata_function}()},
\code{\link{retrieve_data}()},
\code{\link{retrieve_one}()}
}
\concept{retrieve}
