% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ods-PLM.R
\name{Bfct}
\alias{Bfct}
\title{power basis functions of a spline of given degree}
\usage{
Bfct(x, degree, knots, der)
}
\arguments{
\item{x}{n by 1 matrix of the independent variable}

\item{degree}{the order of spline}

\item{knots}{the knots location}

\item{der}{the der-order derivative. The default is 0}
}
\value{
n by (1+degree+nknots) matrix corresponding to the truncated power
  spline basis with knots and specified degree.
}
\description{
\code{Bfct} returns the power basis functions of a spline of given degree.
}
\examples{
library(ODS)

x <- matrix(c(1,2,3,4,5),ncol=1)
degree <- 2
knots <- c(1,3,4)

Bfct(x, degree, knots)
}
