% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ODT.R
\name{plot.ODT}
\alias{plot.ODT}
\title{to plot an oblique decision tree}
\usage{
\method{plot}{ODT}(x, font.size = 17, width.size = 1, xadj = 0, main = NULL, sub = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link{ODT}}.}

\item{font.size}{Font size of plot}

\item{width.size}{Size of eclipse in each node.}

\item{xadj}{The size of the left and right movement.}

\item{main}{main title}

\item{sub}{sub title}

\item{...}{Arguments to be passed to methods.}
}
\value{
Tree Structure.
}
\description{
Draw oblique decision tree with tree structure. It is modified from a function in \code{PPtreeViz} library.
}
\examples{
data(iris)
tree <- ODT(Species ~ ., data = iris, split = "gini")
plot(tree)

}
\references{
Lee, EK(2017) PPtreeViz: An R Package for Visualizing Projection Pursuit Classification Trees, Journal of Statistical Software.
}
\seealso{
\code{\link{ODT}} \code{\link{as.party.ODT}} \code{\link{plot_ODT_depth}}
}
\keyword{plot}
\keyword{tree}
