% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoviceDeveloperResources2.R
\name{sortedInputForCheckBuildInstallSourcePackageDriver}
\alias{sortedInputForCheckBuildInstallSourcePackageDriver}
\title{sortedInputForCheckBuildInstallSourcePackageDriver}
\usage{
sortedInputForCheckBuildInstallSourcePackageDriver(dir, packs, p0, verbose)
}
\arguments{
\item{dir}{character string containing the path name of the directory holding the package folders}

\item{packs}{list of package names}

\item{p0}{list of those packages whose R code has been modified by the developer}

\item{verbose}{if TRUE print line indicating the recursion level}
}
\value{
a list whose components are the return values of checkBuildInstallSourcePackage()
and conflictOfInterestRestricted()
}
\description{
driver to invoke sequence of functions to retrieve the correctly
ordered list of packages as input and to invoke checkBuildInstallSourcePackage()
}
\details{
This driver is the single master function to run in order to invoke
all of the other functions in the packages \emph{NoviceDeveloperResources} and
\emph{NoviceDeveloperResources2}.

In the examples, I show the actual call using
packages that are currently under development, so they are not yet available
(I expect them to be available in mid-2024).
}
\examples{
\dontrun{
# you need to specify dir, packs that are on your own computer !!
dir1<-"~/personal/hearts/hearts_card_game_bayesian_inference"
dir2<-"packages/inference_packages/inference_packages/"
dir<-sprintf("\%s/\%s",dir1,dir2)
packs<-c("cardUtils","clickableImageMap","editDriver",
"heartsCIM","iterationDriver","logos","playOneTrick",
"playWholeHandDriverPassParams","probTab","relaxDriver")
l<-sortedInputForCheckBuildInstallSourcePackageDriver(dir,packs,packs,TRUE)

dir<-"~/personal/hearts/hearts_card_game_bayesian_inference/packages.12.25.23"
packs<-c("parseCreationTime","retrieve","probsDriverDriver","chisqDriver","html",
        "probsRandomDriverDriver","resamplingProbsMatrix","remapping")
lll<-sortedInputForCheckBuildInstallSourcePackageDriver(dir,packs,"retrieve",TRUE)
}

}
