% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nonpareil.R
\name{Nonpareil.curve}
\alias{Nonpareil.curve}
\title{Generates a Nonpareil curve from an .npo file}
\usage{
Nonpareil.curve(
  file,
  plot = TRUE,
  label = NA,
  col = NA,
  enforce.consistency = TRUE,
  star = 95,
  correction.factor = TRUE,
  weights.exp = NA,
  skip.model = FALSE,
  ...
)
}
\arguments{
\item{file}{Path to the .npo file, containing the read redundancy.}

\item{plot}{Determines if the plot should be produced. If FALSE, it computes the
coverage and the model wihtout plotting.}

\item{label}{Name of the dataset. If NA, it is determined by the file name.}

\item{col}{Color of the curve.
If NA, a random color is assigned (even if \code{plot = FALSE}).}

\item{enforce.consistency}{If TRUE, it fails verbosely on insufficient data, otherwise it warns
about the inconsistencies and attempts the estimations.}

\item{star}{Objective coverage in percentage; i.e., coverage value considered
near-complete.}

\item{correction.factor}{Should the overlap-dependent (or kmer-length-dependent) correction
factor be applied? If FALSE, redundancy is assumed to equal coverage.}

\item{weights.exp}{Vector of values to be tested (in order) as exponent of the weights
distribution. If the model fails to converge, sometimes manual
modifications in this parameter may help. By default (NA), five
different values are tested in the following order: For linear
sampling, -1.1, -1.2, -0.9, -1.3, -1. For logarithmic sampling (-d
option in Nonpareil), 0, 1, -1, 1.3, -1.1, 1.5, -1.5.}

\item{skip.model}{If set, skips the model estimation altogether.}

\item{...}{Any additional parameters passed to \code{plot.Nonpareil.Curve}.}
}
\value{
Returns invisibly a \code{Nonpareil.Curve} object
}
\description{
Generates a Nonpareil curve from an .npo file
}
\examples{
# Generate a Nonpareil plot
file <- system.file("extdata", "LakeLanier.npo", package = "Nonpareil")
np <- Nonpareil.curve(file)

# Produce the same plot but using powers of 1,000bp as X axis labels
Nonpareil.curve(file, xaxt = "n", xlab = "Sequencing Effort")
axis(
  1L, at = 10L^seq(3L, 12L, by = 3L),
  labels = paste(1L, c("Kbp", "Mbp", "Gbp", "Tbp"))
)

# Show the estimated values
print(np)

# Predict coverage for 20Gbp
predict(np, 20e9)

# Obtain the Nd diversity index
np$diversity
}
