% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sollis_2004_unit_root.R
\name{Sollis_2004_unit_root}
\alias{Sollis_2004_unit_root}
\title{Sollis(2004) nonlinear unit root test function}
\usage{
Sollis_2004_unit_root(x, model, max_lags)
}
\arguments{
\item{x}{series name,}

\item{model}{if model with intercept 1, if model with trend 2 if model with trend*function 3}

\item{max_lags}{maximum lag(optimal lag selected by AIC)}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"p1=p2=0 Statistic" the value of the test statistic
}
\description{
This function allows you to make Sollis(2004) nonlinear unit root test
}
\examples{
\donttest{
set.seed(123)
x <- rnorm(1000)
Sollis_2004_unit_root(x, model = 1, max_lags = 6)


set.seed(123)
y <- cumsum(rnorm(1000))
Sollis_2004_unit_root(y, 2, 12)


data(IBM)
Sollis_2004_unit_root(x = IBM, model = 3, max_lags = 3)
}

}
\references{
Sollis, R. (2004). Asymmetric adjustment and smooth transitions: a combination of some unit root tests. Journal of time series analysis, 25(3), 409-417.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
