% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvPham.r
\name{InvPham}
\alias{InvPham}
\alias{dinv.pham}
\alias{pinv.pham}
\alias{qinv.pham}
\alias{rinv.pham}
\alias{hinv.pham}
\title{Inverse Pham Distribution}
\usage{
dinv.pham(x, beta, delta, log = FALSE)
pinv.pham(q, beta, delta, lower.tail = TRUE, log.p = FALSE)
qinv.pham(p, beta, delta, lower.tail = TRUE, log.p = FALSE)
rinv.pham(n, beta, delta)
hinv.pham(x, beta, delta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{beta}{positive numeric parameter}

\item{delta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.pham}: numeric vector of (log-)densities
  \item \code{pinv.pham}: numeric vector of probabilities
  \item \code{qinv.pham}: numeric vector of quantiles
  \item \code{rinv.pham}: numeric vector of random variates
  \item \code{hinv.pham}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Pham distribution.
}
\details{
The Inverse Pham distribution is parameterized by the parameters
\eqn{\beta > 0}, and \eqn{\delta > 0}.


The Inverse Pham distribution has CDF:

\deqn{
F(x; \beta, \delta) =
\exp \left( {1 - {\delta ^{{x^{ - \beta }}}}} \right)
\quad ;\;x > 0.
}

where\eqn{\beta} and \eqn{\delta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dinv.pham()} — Density function
  \item \code{pinv.pham()} — Distribution function
  \item \code{qinv.pham()} — Quantile function
  \item \code{rinv.pham()} — Random generation
  \item \code{hinv.pham()} — Hazard function
}
}
\examples{
x <- seq(1, 10, 0.5)
dinv.pham(x, 0.5, 1.5)
pinv.pham(x, 0.5, 1.5)
qinv.pham(0.5, 0.5, 1.5)
rinv.pham(10, 0.5, 1.5)
hinv.pham(x, 0.5, 1.5)

# Data
x <- relief
# ML estimates
params = list(beta=2.8287, delta=9.6044)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.pham, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.pham, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dinv.pham, pfun=pinv.pham, plot=FALSE)
print.gofic(out)

}
\references{
Elbatal, M., Araibi, M.I.A., Ocloo, S.K., Almetwally, E.M., Sapkota, L.P.,  
& Gemeay, A.M. (2025). Classical and Bayesian Methodology for a New Inverse
Statistical Model. \emph{Engineering Reports}, \bold{7(8)}, 1--33. 
\doi{10.1002/eng2.70323} 
  
Srivastava, A.K., & Kumar, V. (2011).  
Analysis of Pham (Loglog) Reliability Model Using Bayesian Approach. 
\emph{Computer Science Journal}, \bold{1(2)}, 79--100. 

Pham, H. (2002).  A Vtub-Shaped Hazard Rate Function With Applications
to System Safety. \emph{International Journal of Reliability and 
Applications}, \bold{3(1)}, 1--16.
}
