% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCGompertz.r
\name{HCGompertz}
\alias{HCGompertz}
\alias{dhc.gpz}
\alias{phc.gpz}
\alias{qhc.gpz}
\alias{rhc.gpz}
\alias{hhc.gpz}
\title{Half-Cauchy Gompertz Distribution}
\usage{
dhc.gpz(x, alpha, lambda, theta, log = FALSE)
phc.gpz(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.gpz(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.gpz(n, alpha, lambda, theta)
hhc.gpz(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.gpz}: numeric vector of (log-)densities
  \item \code{phc.gpz}: numeric vector of probabilities
  \item \code{qhc.gpz}: numeric vector of quantiles
  \item \code{rhc.gpz}: numeric vector of random variates
  \item \code{hhc.gpz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy Gompertz distribution.
}
\details{
The Half-Cauchy Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Half-Cauchy Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad \frac{2}{\pi }\arctan \left\{ { - \frac{\lambda }{{\alpha \theta }}
\left( {1 - {e^{\alpha x}}} \right)} \right\} \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dhc.gpz()} — Density function
  \item \code{phc.gpz()} — Distribution function
  \item \code{qhc.gpz()} — Quantile function
  \item \code{rhc.gpz()} — Random generation
  \item \code{hhc.gpz()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dhc.gpz(x, 2.0, 0.5, 2.5)
phc.gpz(x, 2.0, 0.5, 2.5)
qhc.gpz(0.5, 2.0, 0.5, 2.5)
rhc.gpz(10, 2.0, 0.5, 2.5)
hhc.gpz(x, 2.0, 0.5, 2.5)

# Data
x <- stress66
# ML estimates
params = list(alpha=1.6660, lambda=0.0328, theta=2.0578)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.gpz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.gpz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params, dfun=dhc.gpz, pfun=phc.gpz, plot=TRUE)
print.gofic(out)

}
\references{
Sah, L.B., & Kumar, V. (2019). 
Half-Cauchy Gompertz Distribution : Different Methods of Estimation, 
\emph{Journal of  National Academy of Mathematics}, \bold{33},  51--65.
}
