% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LISAR.R
\name{LISAR}
\alias{LISAR}
\title{The LISAR model}
\usage{
LISAR(
  x,
  Model = "LISAR.LASSO",
  eval.criteria = "MSFE",
  Lags = 3,
  alpha.pens = 0.5,
  gamma.pens = 0.5,
  lambda1_seq = 0.5,
  lambda2_seq = 0.5,
  lambda3_seq = 0.5,
  a.pen = 3.7,
  eps1 = 1e-04,
  eps2 = 1e-04,
  T1 = NULL,
  T2 = NULL,
  reoptim = FALSE
)
}
\arguments{
\item{x}{A matrix containing the data with rows being observations and
columns being time series.}

\item{Model}{The LISAR model to use with either LASSO 
\code{"LISAR.LASSO"}, SCAD \code{"LISAR.SCAD"} or Adaptive LASSO 
\code{"LISAR.AdapLASSO"} regularization. Default \code{"LISAR.LASSO"}.}

\item{eval.criteria}{The evaluation criteria to use to choose the 
best model under the regularization parameters. Can be either \code{"MSFE"}, 
\code{"AIC"} or \code{"BIC"}. Default \code{"MSFE"}.}

\item{Lags}{The maximum number of lags to consider. Default 3.}

\item{alpha.pens}{A number or vector specifying the boosting parameter 
increasing/decreasing the strength of regularization. Should be a number(s) 
between (0,1). See Zhang and Trimborn (2023) for details on the alpha 
parameters.}

\item{gamma.pens}{A number or vector specifying the adaptive parameter 
for \code{"LISAR.AdapLASSO"}. Only required for \code{"LISAR.AdapLASSO"}. The number(s) 
should be larger than 0.}

\item{lambda1_seq}{The factor by which the regularization sequence of 
lambda1, regularizing the lag structure, decreases towards 0. Should be a 
value between (0,1).}

\item{lambda2_seq}{The factor by which the regularization sequence of 
lambda2, indicating which time series are more influential (influencers), 
decreases towards 0. Should be a value between (0,1).}

\item{lambda3_seq}{The factor by which the regularization sequence of 
lambda3, regularizing the individual parameters, decreases towards 0. 
Should be a value between (0,1).}

\item{a.pen}{The parameter specifying by which the SCAD penalty taperes off 
towards no regularization. Only required for \code{"LISAR.SCAD"}. 
The number should be larger than 0. Default \code{3.7}.}

\item{eps1}{Control parameter for the inner optimization algorithm. The algorithm 
converged when between optimization steps the parameters change by less than 
\code{"eps1"}. Default \code{0.0001}.}

\item{eps2}{Control parameter for the outer optimization algorithm. The algorithm 
converged when between optimization steps the parameters change by less than 
\code{"eps2"}. Default \code{0.0001}.}

\item{T1}{A numeric stating the row of \code{"x"} where the training data 
end and the evaluation period starts. If \code{NULL}, then the first third 
of data are chosen as training data. Defaults to \code{NULL}.}

\item{T2}{A numeric stating the row of \code{"x"} where the evaluation data 
end and the out-of-sample period starts. If \code{NULL}, then the second third 
of data are chosen as evaluation data. Defaults to \code{NULL}.}

\item{reoptim}{Logical. If TRUE, then the best model found under the 
initially derived lambda sequences is further optimized by a new lambda 
sequence around the previous best solution. Stops when a more granular 
lambda sequence no longer improves the model under \code{"eval.criteria"} 
criterion. Default \code{"FALSE"}.}
}
\value{
An object of the \code{class} netstruc with the components
\item{Model.optimal}{a list containing the optimal model, evaluation 
criteria and model regularizers}
\item{data.training}{the training data} \item{data.evaluation}{the evaluation 
data} \item{data.outofsample}{the out-of-sample data.} 
\item{Model.estimation}{estimation specifics for the model}
}
\description{
\code{\link{LISAR}} contains the LISAR model described in Zhang and 
Trimborn (2023). The model is computed based on 3 lambda tuning parameters 
which are automatically determined by the package. A scaling parameter 
boosts/lowers the strength of the regularization on assets which values are 
determined less/more important than others (influencers). The function 
allows to compute the LISAR model under \code{"LASSO"}, \code{"SCAD"} and 
\code{"AdapLASSO"}.
}
\examples{

# Investigate influential assets relationship between 3 assets only
data(TradingData)

LISAR(TradingData[,c("AIG", "AXP", "BAC")], Model = "LISAR.LASSO", Lags = 1)

# Reoptimise the penalisation sequence
LISAR(TradingData[,c("AIG", "AXP", "BAC")], Model = "LISAR.LASSO", Lags = 1, reoptim = TRUE)

\donttest{
# Investigate influential assets relationship between the entire asset universe with starting values
LISAR(TradingData, Model = "LISAR.LASSO")

# Reoptimise the penalisation sequence
LISAR(TradingData, Model = "LISAR.LASSO", reoptim = TRUE)

# Consider a different model
LISAR(TradingData, Model = "LISAR.SCAD", Lags = 1)
}
}
\references{
Kexin Zhang, Simon Trimborn (2023).
Influential assets in Large-Scale Vector Autoregressive Models
\emph{SSRN Working paper}.
\doi{http://dx.doi.org/10.2139/ssrn.4619531}\cr \cr
}
