% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdGammaPareto.R
\name{qSlicedGammaPareto}
\alias{qSlicedGammaPareto}
\title{The inverse cumulative density function of a Sliced Gamma Pareto severity distribution}
\usage{
qSlicedGammaPareto(q, GShape, GRate, SlicePoint, PShape)
}
\arguments{
\item{q}{A real number between 0 and 1 -  the probability where the inverse cumulative density function will be evaluated.}

\item{GShape}{A positive real number -  the shape parameter of the attritional Claim Severity's Gamma distribution.}

\item{GRate}{A positive real number -  the rate parameter of the attritional Claim Severity's Gamma distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{PShape}{A positive real number - the shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The value of the inverse cumulative density function at \code{q} with an attritional claim Gamma distribution with parameters \code{GShape} and \code{GRate} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{PShape}.
}
\description{
The inverse cumulative density function of a Sliced Gamma Pareto severity distribution
}
\examples{
qSlicedGammaPareto(0.5,1,0.0005,1000,1.2)
qSlicedGammaPareto(0.2,1.1,0.0006,2000,1.6)
qSlicedGammaPareto(0.8,1.2,0.0004,3000,1.4)
}
